/******************************************************************************
* (C) Copyright 2007 by Agilent Technologies, All Rights Reserved.
******************************************************************************/

#ifndef PCIEFPGAFRAMEWORK_H
#define PCIEFPGAFRAMEWORK_H

#include "PCIEFPGATxMemories.h"
#include "PCIEFPGACSPkt.h"
#include "PCIEConfigSpace.h"
#include "PCIEFPGACSDat.h"
#include "PCIEFPGACSSpc.h"
#include "PCIeFPGAcsmis.h"

class CPCIEFpgaFramework
{
public:
  // = FOUNDATION
  CPCIEFpgaFramework( void );
  ~CPCIEFpgaFramework( void );

  static CPCIEFpgaFramework &instance( void );

  // = DELEGATORS
  CPCIEFpgaTxMemories& getFpgaTxMemories( void );
  CPCIEFpgaCSPkt& getFpgaCSPkt( void );
  CPCIEConfigSpace& getConfigSpace( void );
  CPCIEFpgaCSDat& getFpgaCSDat( void );
  CPCIEFpgaCSSpc& getFpgaCSSpc( void );
  CPCIEFpgaCSMis& getFpgaCSMis( void );

  void CompleterRun( const AgtPortHandleT& portHandle );

private:

  CPCIEFpgaTxMemories        mFPGATxMemories;
  CPCIEFpgaCSPkt             mFPGACSPkt;
  CPCIEConfigSpace           mPCIEConfigSpace;
  CPCIEFpgaCSDat             mFPGACSDat;
  CPCIEFpgaCSSpc             mFPGACSSpc;
  CPCIEFpgaCSMis             mFPGACSMis;
};

#endif /* PCIEFPGAFRAMEWORK_H */